<?php

namespace Plenty\Modules\Order\Models;

use Illuminate\Database\Eloquent\Model;

class OrderDateOption extends Model 
{

    protected $table = 'plenty_order_date_option';
    public $timestamps = true;
    protected $guarded = array('id');
    protected $fillable = array('orderId', 'typeId', 'date');
    protected $visible = array('id', 'orderId', 'typeId', 'date', 'createdAt', 'updatedAt');

    public function type()
    {
        return $this->hasOne('OrderDateOptionType', 'id', 'typeId');
    }

    public function orders()
    {
        return $this->belongsTo('Order', 'orderId');
    }

}